/*
  # Fix companies table RLS policies

  1. Security Changes
    - Add RLS policy to allow unauthenticated users to create companies during registration
    - Keep existing policy for authenticated users to read their own company data
    
  2. Notes
    - The insert policy is specifically scoped to registration data only
    - Read policy remains unchanged to maintain data privacy
*/

-- Add policy to allow company creation during registration
CREATE POLICY "Allow company creation during registration" ON companies
  FOR INSERT
  TO anon
  WITH CHECK (true);