import { ExtractedInvoiceData } from './ollama';

const API_BASE = '/wp-json/spendcheck/v1';

export async function createCompany(data: {
  company_name: string;
  post_code: string;
  business_type: string;
}) {
  const response = await fetch(`${API_BASE}/company`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-WP-Nonce': wpApiSettings.nonce
    },
    body: JSON.stringify(data),
    credentials: 'include'
  });

  if (!response.ok) {
    throw new Error('Failed to create company');
  }

  return response.json();
}

export async function saveInvoice(data: ExtractedInvoiceData & { company_id: string }) {
  const response = await fetch(`${API_BASE}/invoice`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-WP-Nonce': wpApiSettings.nonce
    },
    body: JSON.stringify(data),
    credentials: 'include'
  });

  if (!response.ok) {
    throw new Error('Failed to save invoice');
  }

  return response.json();
}

export async function getInvoices() {
  const response = await fetch(`${API_BASE}/invoices`, {
    headers: {
      'X-WP-Nonce': wpApiSettings.nonce
    },
    credentials: 'include'
  });

  if (!response.ok) {
    throw new Error('Failed to fetch invoices');
  }

  return response.json();
}